//
//		Definition of the String Manager class
//
//
#ifndef THE_STRING_MANAGER_H
#define THE_STRING_MANAGER_H

#include "ldwFont.h"

#define numRandomTips 50

enum StringId
{
	eNoString = -1,

	eNULLString = 0,

	eTIME_STOPPED,

	//ISOLA STRINGS
	//DEALER SAY'S

	eSayFood,
	//eSayTechPoints,
	eSayBetterFarming,
	eSayVillagerSelected,
	eSayClickToZoom,
	eSayClickToContinue,
	eSayTryingToLearn,
	eSayEatingHealed,

	eSayWelcome,
	eSayBetterAlchemy,
	eSayTryingToResearch,
	eSayBetterResearch,
	eSayMasteredHerb,
	eSayFailedResearch,
	eSayOuch,
	eSayFailedSkill,
	eSayBetterBreeding,
	eSayAlreadyMaster,
	eSayBetterConstruction,
	eSayConfusedTech,
	eSayLearnFailed,
	eSayBetterHealing,
	eSayNeedFirewood,
	eSayNeedSpecialFish,
	eSayNeedKindling,
	eSayOnlyChildren,
	eSayOnlyScientist,
	eSayOnlyScientistCanPolish,
	eSayOnlyChiefCanTouchPearl,
	eSayDiamondTooHotToPickup,
	eSayDiamondTooHot,
	eSayFoodLevel,
	eSayBriarProgress,
	eSayConcernedFood,
	eSaySickCannotMate,
	eSayUnknown,
	eSayAlreadyPregnant,
	eSaySameGender,
	eSayNoClick,
	eSayNoNoFruit,
	eSayConcernedHousing,
	eSayAlreadyDoneToday,
	eSayWellWaterGarden,
	eSayTooYoung,
	eSayTooOld,
	eSayGameOver,
	eSayNoFruit,
	eSaySkillSet,
	eSayNoBerries,
	eSayFullyResearched,
	eSayTooDirty,
	eSayInsufficientTechPts,
	eSayDaughterOf,
	eSaySonOf,
	eSayChiefDontWork,
	eSayOnlyRegistered,
	eSayNoFishing,
	eSayIsDead,
	eSayFoundCrab,
	eSayGamePaused,
	eTechPointsAvailable,
	eTechNotAvailableInDemo,
	eSayTechPoints,
	eSayTechPointsTable,
	eSayHoneyAvailable,
	eSayBlockageProgress,
	eSayIdolProgress,
	eSayHoneyRemaining,
	eSayHut1Progress,
	eSayHut2Progress,
	eSayHut3Progress,
	eSayVinesProgress,
	eSayLoveshackProgress,
	eSayHospitalProgress,
	eSayClothingHutProgress,
	eSayFireProgress,
	eSayDamProgress,
	eSayMosaicProgress,
	eSayFarmStatus,
	eSayTempleProgress,
	eSayTimeUntilMature,
	eSayStatueNeedsRepairing,
	eSayTimeUntilRepaired,
	eSayStatueRepaired,
	eSayBathNeedsRepairing,
	eSayBathProgress,
	eSayBathRepaired,
	eSayBrokenLift,
	eSayLiftRepaired,
	eSayFruitRemaining,
	eSayNotEnoughToHarvest,
	eSayRuins,
	eSayRuinsProgress,
	eSayRoster,
	eSayRosterProgress,
	eSayChalkBoard,
	eSayChalkBoardPlans,
	eSayTechPointsAvail,
	eSayKidsCantSwim,
	eSaySeesBeeHive,
	eSayOnlyAdeptBuilder,
	eSayOnlyMasterBuilder,
	eSayNeedPlans,
	eSayAlreadyContainsPlans,
	eSayNoRepairNeeded,
	eSayConfirmDelete,
	eSayConfirmRestart,
	eSayGoodDrag,
	eSayGoodVillagerDrag,
	eSayOnlyMasterFarmer,
	eSayPuzzleIncomplete,
	eSayCommonTurtleShells,
	eSayUncommonTurtleShells,
	eSayRareTurtleShells,
	eSayCommonCoral,
	eSayUncommonCoral,
	eSayRareCoral,
	eSayCommonTablet,
	eSayUncommonTablet,
	eSayRareTablet,
	eSayCommonFeathers,
	eSayUncommonFeathers,
	eSayRareFeathers,
	eSayKeysFound,
	eSayInternalError,
	eSayOK,
	eSayHelp,
	eSayMenu,
	eSayCredits,
	eSayPuzzles,
	eSayCollections,
	eSayMap,
	eSayTech,
	eSayDetail,
	eSayYes,
	eSayNo,
	eSaySkipIntro,
	eSayExpired,
	eSayLoading,
	eSayPopulation,
	eSayName,
	eSaySkill,
	eSayAction,
	eSayUntrained,
	eSayNovice,
	eSayApprentice,
	eSayTrainee,
	eSayAdept,
	eSayMaster,
	eSayElder,
	eSayChief,
	eSayFarmer,
	eSayParent,
	eSayBuilder,
	eSayScientist,
	eSayDoctor,
	eSayDone,
	eSaySeesMushroom,
	eSayLookingExcitedly,
	eSaySeesClothingHutSite,
	eSayRestHospital,
	eSayCannotBuyClothes,
	eSaySeesOcean,
	eSaySeesSomething,
	eSayCoconutsEmpty,
	eSayBushEmpty,
	eSayTryWork,
	eSayCouldTryResearch,
	eSaySeesTheFirePit,
	eSaySeesTheFire,
	eSaySeesTheStewBeingMade,
	eSaySeesKindling,
	eSaySeesBrokenLift,
	eSaySeesLift,
	eSaySeesFirewood,

	eSaySeesHerb1,
	eSaySeesHerb2,
	eSaySeesHerb3,
	eSaySeesHerb4,
	eSaySeesHerb5,
	eSaySeesHerb6,
	eSaySeesHerb7,

	eSaySeesHospital,
	eSaySeesClothingHut,
	eSaySeesLoveShack,
	eSaySeesSomethingHanging,
	eSaySeesBath,
	eSaySeesBrokenBath,
	eSaySeesStonePile,
	eSaySeesRubble,
	eSaySeesCaveEntrance,
	eSaySeesLeaves,
	eSaySeesRoster,
	eSaySeesFoodbin,
	eSaySeesLowFoodbin,
	eSaySeesAbundantFoodbin,
	eSaySeesEmptyFoodbin,
	eSaySeesClam,
	eSaySeesClamClosing,
	eSaySeesPearl,
	eSaySeesAlchemyPot,
	eSaySeesBrokenAlchemyPot,
	eSaySeesAlchemyTable,
	eSaySeesBrokenTable,
	eSaySeesCorpse,
	eSaySeesVillager,
	eSaySeesVillagerWithBaby,
	eSaySeesShark,
	eSaySeesSharks,
	eSaySeesAmphitheatre,
	eSaySeesAmphitheatreCape,
	eSaySeesStatueStart,
	eSaySeesClifftree,
	eSaySeesResearchEquipment,
	eSaySeesResearchTable,
	eSaySeesDebris,
	eSaySeesDiskRoom,
	eSaySeesMountain,
	eSaySeesSunDisk,
	eSaySeesHouse,
	eSaySeesDamagedHouse,
	eSaySeesSignificantlyDamagedHouse,
	eSaySeesSeverelyDamagedHouse,
	eSaySeesStatue,
	eSaySeesFallenStatue,
	eSaySeesPuddle,
	eSaySeesTree,
	eSaySeesYoungTree,
	eSaySeesGrave,
	eSaySeesChalkBoard,
	eSaySeesChalkBoardPlans,
	
	
	
	
	eSaySeesSacredArea,
	
	
	
	
	eSaySomeonesRemains,
	eSayPlay,
	eSayStartOver,
	eSayOptions,  
	eSayQuit,
	eSayBuyNow,
	eSayChangePlayer,
	eSayCurrentPlayer,
	eSayBuy,
	eSayTechPointsCln,
	eSayTechnologies,
	eSayLevel1,
	eSayLevel2,
	eSayLevel3,
	eSayFaction,
	eSayLeadership,
	eSayFarming,
	eSayMedicine,
	eSayExploration,
	eSayConstruction,
	eSayScience,
	eSayCulture,
	eSayHereLies,
	eSayJob,
	eSayAge,
	eSortBy,
	eSayHealth,
	eSayDecomposing,
	eSayNothing,
	eSayGoingVlgCenter,
	eSayMeditating,
	eSayNatureCalling,
	eSayGettingNewClothes,
	eSayStrolling,
	eSayExercising,
	eSayCuriousCreek,
	eSayCuriousDryGrass,
	eSayCuriousRoster,
	eSayCuriousCoconuts,
	eSayCuriousVines,
	eSayCuriousDrySoil,
	eSayCuriousFire,
	eSaySeesUnusual,
	eSayRainDancing,
	eSayLaundry,
	eSayChatting,
	eSayTellingJoke,
	eSayArguing,
	eSayComplaining,
	eSayPraising,
	eSayTeaching,
	eSayNotFeelWell,
	eSayAgitated,
	eSayForaging,
	eSayBuildingHut,
	eSayBuildingHospital,
	eSayBuildingClothingHut,
	eSayHarvestingCoconuts,
	eSayBuilgingHospital,
	eSayExaminingHut,
	eSayFixingHut,
	eSayHonoringMosaic,
	eSayChiseling,
	eSayRebuildingLoveshack,
	eSayResearching,
	eSayEnjoyingGarden,
	eSayGoingIndoors,
	eSayGatheringFirewood,
	eSayStartingFire,
	eSayMakingCuttingTool,
	eSayRetrievingPot,
	eSayGatheringKindling,
	eSayRunningAway,
	eSayNotEnoughLeadership,
	eSayRunningFromSharks,
	eSayCuriousAboutField,
	eSayNeedAdeptResearcher,
	eSayfuitlessPlant,
	eSayEnjoyMagicFruit,
	eSayStudyCactus,
	eSayStudyLily,
	eSayStudyRose,
	eSayStudyPlant,
	eSayBuryDead,
	eSayPlantingCrops,
	eSayHarvestCrops,
	eSayHonoringStatue,
	eSayCelebrating,
	eSayHonoring,
	eSayRestoreRuins,
	eSayNoFood,
	eSayNoFire,
	eSayNeedsMoreIngredients,
	eSayStewIsReady,
	eSayRemovingBriars,
	eSayPickingMushroom,
	eSayPickingCollectable,
	eSayPickingUncommonCollectable,
	eSayPickingRareCollectable,
	eSayPickingOldCollectable,
	eSayEnoughHerbs,
	eSayRobeWontFit,
	eSayNeedMoreHerbs,
	eSayHerbsReady,
	eSayLabInRuins,
	eSayAlchemistPresent,
	eSayLeftBurnedTorch,
	eSaySwimming,
	eSayDiving,
	eSayHuntingFish,
	eSayTellStory,
	eSayListenStory,
	eSayWateringCrops,
	eSayWaterStrangePatch,
	eSayWaitingSomeone,
	eSayEmbracing,
	eSayHealing,
	eSayCuriousCactus,
	eSayChasingButterflies,
	eSayCaringForBaby,
	eSayGoToSchool,
	eSayLecture,
	eSayWired,
	eSayWiredMale,
	eSayWiredFemale,
	eSayPlayInLab,
	eSayStompAnts,
	eSayHidingInHut,
	eSayDoMagicDance,
	eSayReturningWithPrize,
	eSayRunToRescue,
	eSayDrinkingRain,
	eSayDoingLaundry,
	eSayActingEvil,
	eSayDayOfHonor,
	eSayBlessingsDay,
	eSayIsolaDay,
	//eSayWorriedFood,
	eSayUnsure,
	eSayShakingHead,
	eSayItsRaining,
	eSayLikesList,
	eSayDislikesList,
	eSayVillagerDetail,
	eSaySkills,
	eSayResearch,
	eSayBreeding,
	eSayBuilding,
	eSayHealingDetail,
	eSayGender,
	eSayStatus,
	eSayLikes,
	eSayDislikes,
	eSayWeaningIn,
	eSayMale,
	eSayFemale,
	eSayDead,
	eSaySick,
	eSayWeakened,
	eSayElderly,
	eSayHealthy,
	eSayNursingFor,
	eSayMin,
	eSayGuidingHand,
	eSayCoolFeet,
	eSayTeachChildren,
	eSayFailedPotion,
	eSayAttendLessons,
	eSayPlayTag,
	eSayPlayTagIt,
	eSayHonorTotem,
	eSayHe,
	eSayShe,
	eSayHeSmall,
	eSaySheSmall,
	eSayHimSmall,
	eSayHerSmall,
	eSayHisSmall,
	eSayNext,
	eSayPrev,
	eSayChooseClothes,
	eSayTastesBitter,
	eSayHic,
	eSayYikes,
	eSayWoah,
	eSayYummy,
	eSayBurns,
	eSayFeelsBetter,
	eSayLearnsFaster,
	eSayTechBonus,
	eSayFeelsLikeNew,
	eSayCantDrinkAgain,
	eSayHealedButStarving,
	eSayFeelsLight,
	eSayFeelsRomantic,
	eSayFeelsHungry,
	eSayFeelsItchy,
	eSayFeelsFertile,
	eSayFeelsDown,
	eSayFeelsSleepy,
	eSayFeelsATrance,
	eSayFeelsVeryFertile,
	eSayFeelsTired,
	eSayFeelsFaint,
	eSayFeelsHappy,
	eSayNeedsWarming,
	eSayNeedsCooling,
	eSayHasStomachAche,
	eSayAwfulPotion,
	eSayCantMove,
	eSayGotToGo,
	eSayIsEveryoneSlow,
	eSayMustExercise,
	eSayFunPotion,
	eSayTooHot,
	eSayNoPotion,
	eSayTooCold,
	eSayTrance,
	eSaySprituality,
	eSayParalyzed,
	eSayBadDancingChief,
	eSayBadDancing,
	eSayGarlicBreath,
	eSayBubbleBreath,
	eSayHiccups,
	eSayPlayInDirt,
	eSayBlind,
	eSayCrazy,
	eSayGoingToSweetPotion,
	eSayTeachingBabyToTalk,
	eSayCleaningUpMud,
	eSayPlayingInSand,

	eSayPotionReady,
	eSayItchy,
	eSayFaint,
	eSayTryToReachKey,
	eSayClearingRubble,
	eSayScareBees,
	eSayHarvestFruit,
	eSayPlantingTree,
	eSayPushingStatue,
	eSayBuildingScaffolding,
	eSayGatherHerbs,

	eSayGetOutOfRain,
	eSayTryOnRobe,
	eSayInspectingFood,
	eSayWeatherDancing,
	eSayContemplateTribe,
	eSayRetrievingDoorkey,
	eSayProudOfTribe,
	eSaySpawnRare,
	eSayThinking,
	eSayConcernedSick,
	eSayCuringTribe,
	eSayCreateMagicFood,
	eSayInspectLabs,
	eSayPlaying,
	eSayStomping,
	eSayStungByJFish,
	eSayWashFace,
	eSayWashHands,
	eSayBathing,
	eSayLookAtFishies,
	eSayLookForMushrooms,
	eSayLookForCollectibles,
	eSayStumbling,
	eSayDoingExercise,
	eSaySwimWithFish,

	eSayCuriousClothes,
	eSayAmazedStatue,
	eSayCuriousStatue,
	eSayAdmiringRoom,
	eSayCuriousDoor,
	eSayCuriousGiantClam,
	eSayCuriousBeehive,
	eSayCuriousMachine,
	eSayCuriousRubble,
	eSayCuriousRuins,
	eSayCuriousBath,
	eSaySoopingAlchemy,
	eSayCuriousThisRoom,
	eSayCuriousHangingThing,
	eSayEnjoyOrchard,
	eSayCuriousDarkSoil,
	
	eSayCuriousHerb1,
	eSayCuriousHerb2,
	eSayCuriousHerb3,
	eSayCuriousHerb4,
	eSayCuriousHerb5,
	eSayCuriousHerb6,
	eSayCuriousHerb7,

	eSayLookRoster,
	eSayHarvestHoney,
	eSayRepairBath,
	eSayPlaySeesaw,
	eSayLonely,
	eSayShowBabyReef,
	eSayWashBaby,
	eSayChangeBaby,
	eSayWatchPeopleWork,
	eSayRepairLift,
	eSayStandLift,
	eSayDoAlchemy,
	eSayEmptyPot,
	eSayUsePotion,
	eSayDirectWork,
	eSayRefusing,
	//eSayGatherHerbs,
	eSayBuildScaffold,
	eSayPushStatue,
	eSayPlantTree,
	eSayPuttingWaterOnFire,
	eSayShapingPearl,
	eSayPolishingPearl,
	eSayTryIdea,
	eSayClearRubble,
	eSayClearLeaves,
	eSayReachKey,
	eSayNeedLieDown,
	eSayNeedSitDown,
	eSayCarryVialToOcean,
	eSayLookForGrownup,
	eSayLookForGrownup2,
	eSayPlayPuddles,
	eSayShowBees,
	eSayInspectHut,
	eSayShowHerbs,
	eSayHidingSomething,
	eSaySpringCleaning,
	eSayShowBabyOrchards,
	eSayShowBabyAmp,
	eSaySunBaby,
	eSayPracticeDance,
	eSayTryGetWarm,
	eSayDrawPlans,
	eSayAromatherapy,
	eSayLightBurners,
	eSaySwapPearl,
	eSayDepositFood,
	eSayReconstructLab,


	//END DEALER SAY's
	eStatisicsLabel,
	eAchievementsLabel,
	eSTotemSuffix,
	eSRemainsSuffix,
	eCollectFishSuffix,
	//TUT TIPS

	eIntroPage1Line1,
	eIntroPage1Line2,
	eIntroPage2Line1,
	eIntroPage2Line2,
	eIntroPage2Line3,
	eIntroPage2Line4,
	eIntroPage3Line1,
	eIntroPage3Line2,
	eIntroPage3Line3,
	eIntroPage3Line4,
	eIntroPage5Line1,
	eIntroPage5Line2,
	eIntroPage5Line3,
	eMidGamePage1Line1,
	eMidGamePage1Line2,
	eMidGamePage1Line3,
	eMidGamePage2Line1,
	eMidGamePage2Line2,
	eMidGamePage2Line3,
	eMidGamePage2Line4,
	eMidGamePage2Line5,
	eMidGamePage2Line6,
	eMidGamePage2Line7,
	eMidGamePage2Line8,
	eMidGamePage2Line9,
	eMidGamePage2Line10,
	eMidGamePage2Line11,
	eMidGamePage2Line12,
	eMidGamePage2Line13,
	eMidGamePage3Line1,
	eMidGamePage3Line2,
	eMidGamePage3Line3,
	eMidGamePage3Line4,
	eEndGamePage1Line1,
	eEndGamePage1Line2,
	eEndGamePage1Line3,
	eEndGamePage2Line1,
	eEndGamePage2Line2,
	eEndGamePage2Line3,
	eEndGamePage2Line4,
	eEndGamePage2Line5,
	eEndGamePage2Line6,
	eEndGamePage2Line7,
	eEndGamePage2Line8,
	eEndGamePage2Line9,
	eEndGamePage3Line1,
	eEndGamePage3Line2,
	eEndGamePage3Line3,
	eEndGamePage4Line1,
	eEndGamePage4Line2,
	eEndGamePage4Line3,
	eEndGamePage4Line4,
	eEndGamePage4Line5,
	eEndGamePage4Line6,
	eEndGamePage4Line7,
	eEndGamePage4Line8,

	eReplayTutorialInstruction,

	eTTipBeginNewTTips,
	eTTipInstruct1, //  = eTTipBeginNewTTips,
	eTTipInfo2,
	eTTipInstruct3,
	eTTipInfo4,
	eTTipInstruct5,
	eTTipInfo6,
	eTTipInstruct7,
	eTTipInfo8,
	eTTipInstruct9,
	eTTipInfo10,
	eTTipInstruct11,
	eTTipInfo12,
	eTTipInstruct13,
	eTTipInfo14,
	eTTipInstruct15,
	eTTipInfo16,
	eTTipInstruct17,
	eTTipInfo18,
	eTTipInstruct19,
	eTTipInfo20,
	eTTipInstruct21,
	eTTipInfo22,
	eTTipInstruct23,
	eTTipInfo24,
	eTTipInstruct25,
	eTTipInfo26,
	eTTipInstruct27,
	eTTipInfo28,
	eTTipInstruct29,
	eTTipInfo30,
	eTTipInstruct31,
	eTTipInfo32,
	eTTipInstruct33,
	eTTipInfo34,

	eTTipLastInfoTip = eTTipInfo34,

	eTTipStandAloneWelcome,
	eTTipStandAloneDragFail,
	eTTipStandAloneHoneyWait,
	eTTipStandAloneHoneyFail,
	eTTipStandAloneResearchWait,
	eTTipStandAloneResearchFail,
	eTTipStandAloneBreedFail,
	eTTipStandAloneFirstPreg,
	eTTipStandAloneHealFail,
	eTTipStandAloneFirstDeath,
	eTTipStandAloneMiniMap,
	eTTipStandAloneRealTime,
	eTTipStandAloneFinal,
	eTTipStandAloneConfused,
	eTTipStandAloneSkillPref,
	//eTipStandAloneFirstCollectable,
	eTTipStandAloneChildrenNoWork,
	eTTipStandAloneMommiesNoWork,
	eTTipTerminator,

	eTipInternalUse,

	eTipFirstTrainee,
	eTipFirstAdept,

	eTipFoodOk,
	eTipFirstAdult,

	eTipLastAutoOff,
	
	
	
	eTipFirstMaster,
	eTipFirstAlchemyFailure,
	eTipPopMilestoneSmall,
	eTipPopMilestoneMed,
	eTipPopMilestoneLarge,
	eTipAbsPopCap,
	eTipNewRecipe,
	eTipYouLose, //66?

	eTipPuzzleBeehiveCleared,
	eTipPuzzleAlchemyLabRestored,
	eTipPuzzleRainLiftRestored,
	eTipPuzzleChiefCreated,
	eTipPuzzlePotionsMade,
	eTipPuzzleAncientBathsRestored,
	eTipPuzzleOrchardStarted,
	eTipPuzzleRainDanceMastered,
	eTipPuzzleDigRestored,
	eTipPuzzlePrincessRestored,
	eTipPuzzleSharksCleared,
	eTipPuzzleRosterDeadCleared,
	eTipPuzzleTreeKeyFound,
	eTipPuzzleAshKeyFound,
	eTipPuzzleClamKeyFound,
	eTipPuzzleSundiskMastered,
	eTipPuzzleAromatherapyMastered,

	eTipPuzzleHut1Built,
	eTipPuzzleClothingHutBuilt,
	eTipPuzzleFireStarted,

	//collection puzzle tips
	eTipPuzzleTurtleShellCollectionComplete,
	eTipPuzzleCoralCollectionComplete,
	eTipPuzzleTabletCollectionComplete,
	eTipPuzzleFeatherCollectionComplete,
	eTipPuzzleAllCollectionsComplete,

	eTipTerminator,
	//END TUT TIPS

	eEulogyDefault,
	eEulogyTextFarmer1,
	eEulogyTextFarmer2,
	eEulogyTextResearcher1,
	eEulogyTextResearcher2,
	eEulogyTextBreeder1,
	eEulogyTextBreeder2,
	eEulogyTextDoctor1,
	eEulogyTextDoctor2,
	eEulogyTextBuilder1,
	eEulogyTextBuilder2,
	eEulogyTextChild1,
	eEulogyTextChild2,
	eEulogyTextElder1,
	eEulogyTextChief,

	eStringCauseOfDeathUnknown,
	eStringCauseOfDeathDisease,

	eStringCauseOfDeathBase = eStringCauseOfDeathDisease,

	eStringCauseOfDeathStarvation,
	eStringCauseOfDeathOldAge,
	eStringCauseOfDeathVocationalInjury,
	eStringCauseOfDeathActOfNature,

	eStringCauseOfDeath,
	eStringRosterOfTheDead,

	//BEGIN EVENT STRINGS

	eEventTsunamiTitle,	
	eEventTsunamiDesc,

	eEventPlagueOfAntsTitle,	
	eEventPlagueOfAntsDesc,

	eEventScienceFairTitle,	
	eEventScienceFairDesc,

	eEventAllergySeasonTitle,	
	eEventAllergySeasonDesc,

	eEventIsolaDayTitle,	
	eEventIsolaDayDesc,

	eEventTheChiefsAddressTitle,
	eEventTheChiefsAddressDesc,

	eEventTheRainySeasonTitle,
	eEventTheRainySeasonDesc,

	eEventTheColdSnapTitle,
	eEventTheColdSnapDesc,

	eEventTheSwarmOfBeesTitle,
	eEventTheSwarmOfBeesDesc,
	//eEventDayOfHonorTitle,	
	//eEventDayOfHonorDesc,

	eEventTheSaltyAirTitle,
	eEventTheSaltyAirDesc,

	eEventTheOppressiveHumidityTitle,
	eEventTheOppressiveHumidityDesc,

	eEventPelicanGriefTitle,
	eEventPelicanGriefDesc,

	eEventTheHungrySharkTitle,
	eEventTheHungrySharkDesc,

	eEventFoggyHeadedTitle,
	eEventFoggyHeadedDesc,

	eEventTheStingingJellyfishTitle,
	eEventTheStingingJellyfishDesc,

	eEventTheMushroomCelebrationTitle,
	eEventTheMushroomCelebrationDesc,

	eEventTheYellowGeckosTitle,
	eEventTheYellowGeckosDesc,

	eEventCanoeFromOtherSideTitle,	
	eEventCanoeFromOtherSideDesc,

	eEventMysteriousFogFoodBonusTitle,	
	eEventMysteriousFogFoodBonusDesc,

	eEventMysteriousFogFoodPenaltyTitle,	
	eEventMysteriousFogFoodPenaltyDesc,

	eEventMysteriousFogTechBonusTitle,	
	eEventMysteriousFogTechBonusDesc,

	eEventMysteriousFogTechPenaltyTitle,	
	eEventMysteriousFogTechPenaltyDesc,

	eEventDayOfHonorTitle,	
	eEventDayOfHonorDesc,

	eEventBlessingsDayTitle,	
	eEventBlessingsDayDesc,

	eEventMiraculousBloomTitle,	
	eEventMiraculousBloomDesc,

	eEventTheReflectionInTheWaterTitle,	
	eEventTheReflectionInTheWaterDesc,


	eEventAnotherBarrelOBabiesTitle,	
	eEventAnotherBarrelOBabiesDesc,

	eEventDaredevilTitle,
	eEventDaredevilDesc,
	eEventDaredevilChoiceA,
	eEventDaredevilChoiceB,
	eEventDaredevilResultA1,
	eEventDaredevilResultA2,
	eEventDaredevilResultB,

	eEventGhostlyNatureDreamTitle,		
	eEventGhostlyNatureDreamDesc,
	eEventGhostlyNatureDreamChoiceA,
	eEventGhostlyNatureDreamChoiceB,
	eEventGhostlyNatureDreamResultA,
	eEventGhostlyNatureDreamResultB,

	eEventGhostlyMagicDreamTitle,		
	eEventGhostlyMagicDreamDesc,
	eEventGhostlyMagicDreamChoiceA,
	eEventGhostlyMagicDreamChoiceB,
	eEventGhostlyMagicDreamResultA,
	eEventGhostlyMagicDreamResultB,


	eEventXtalOfReflectionsTitle,		
	eEventXtalOfReflectionsDesc,
	eEventXtalOfReflectionsChoiceA,
	eEventXtalOfReflectionsChoiceB,
	eEventXtalOfReflectionsResultA,
	eEventXtalOfReflectionsResultB,


	eEventBitterBrownBeansScience1Title,		
	eEventBitterBrownBeansScience1Desc,
	eEventBitterBrownBeansScience1ChoiceA,
	eEventBitterBrownBeansScience1ChoiceB,
	eEventBitterBrownBeansScience1ResultA,
	eEventBitterBrownBeansScience1ResultB,

	eEventBitterBrownBeansScience2Title,		
	eEventBitterBrownBeansScience2Desc,
	eEventBitterBrownBeansScience2ChoiceA,
	eEventBitterBrownBeansScience2ChoiceB,
	eEventBitterBrownBeansScience2ResultA,
	eEventBitterBrownBeansScience2ResultB,

	eEventAncientTabletScience1Title,		
	eEventAncientTabletScience1Desc,
	eEventAncientTabletScience1ChoiceA,
	eEventAncientTabletScience1ChoiceB,
	eEventAncientTabletScience1ResultA,
	eEventAncientTabletScience1ResultB,

	eEventAncientTabletScience2Title,		
	eEventAncientTabletScience2Desc,
	eEventAncientTabletScience2ChoiceA,
	eEventAncientTabletScience2ChoiceB,
	eEventAncientTabletScience2ResultA,
	eEventAncientTabletScience2ResultB,

	eEventTheLowTideTitle,		
	eEventTheLowTideDesc,
	eEventTheLowTideChoiceA,
	eEventTheLowTideChoiceB,
	eEventTheLowTideResultA1,
	eEventTheLowTideResultA2,
	eEventTheLowTideResultB,

	eEventAntsAndGranaryTitle,		
	eEventAntsAndGranaryDesc,
	eEventAntsAndGranaryChoiceA,
	eEventAntsAndGranaryChoiceB,
	eEventAntsAndGranaryResultA,
	eEventAntsAndGranaryResultB,

	eEventTheGreenPearlTitle,		
	eEventTheGreenPearlDesc,
	eEventTheGreenPearlChoiceA,
	eEventTheGreenPearlChoiceB,
	eEventTheGreenPearlResultA,
	eEventTheGreenPearlResultB,

	eEventTheBluePearlTitle,		
	eEventTheBluePearlDesc,
	eEventTheBluePearlChoiceA,
	eEventTheBluePearlChoiceB,
	eEventTheBluePearlResultA,
	eEventTheBluePearlResultB,

	eEventTheLazyApprenticeTitle,		
	eEventTheLazyApprenticeDesc,
	eEventTheLazyApprenticeChoiceA,
	eEventTheLazyApprenticeChoiceB,
	eEventTheLazyApprenticeResultA,
	eEventTheLazyApprenticeResultB,

	eEventTheOmenInTheCloudsTitle,		
	eEventTheOmenInTheCloudsDesc,
	eEventTheOmenInTheCloudsChoiceA,
	eEventTheOmenInTheCloudsChoiceB,
	eEventTheOmenInTheCloudsResultA1,
	eEventTheOmenInTheCloudsResultA2,
	eEventTheOmenInTheCloudsResultA3,
	eEventTheOmenInTheCloudsResultA4,
	eEventTheOmenInTheCloudsResultB,

	eEventThePlayfulOttersTitle,		
	eEventThePlayfulOttersDesc,
	eEventThePlayfulOttersChoiceA,
	eEventThePlayfulOttersChoiceB,
	eEventThePlayfulOttersResultA,
	eEventThePlayfulOttersResultB,

/*
	eEventTheSirenSongTitle,		
	eEventTheSirenSongDesc,
	eEventTheSirenSongChoiceA,
	eEventTheSirenSongChoiceB,
	eEventTheSirenSongResultA1,
	eEventTheSirenSongResultA2,
	eEventTheSirenSongResultB,
*/


	eEventTheAntHillTitle,		
	eEventTheAntHillDesc,
	eEventTheAntHillChoiceA,
	eEventTheAntHillChoiceB,
	eEventTheAntHillResultA,
	eEventTheAntHillResultB,

	eEventTheRedStarfishTitle,		
	eEventTheRedStarfishDesc,
	eEventTheRedStarfishChoiceA,
	eEventTheRedStarfishChoiceB,
	eEventTheRedStarfishResultA,
	eEventTheRedStarfishResultB,


	eEventTheBlueStarfishTitle,		
	eEventTheBlueStarfishDesc,
	eEventTheBlueStarfishChoiceA,
	eEventTheBlueStarfishChoiceB,
	eEventTheBlueStarfishResultA,
	eEventTheBlueStarfishResultB,

	/*
	eEventTheEternalTorchTitle,		
	eEventTheEternalTorchDesc,
	eEventTheEternalTorchChoiceA,
	eEventTheEternalTorchChoiceB,
	eEventTheEternalTorchResultA,
	eEventTheEternalTorchResultB,
	*/

	eEventTheAntInTheBedTitle,		
	eEventTheAntInTheBedDesc,
	eEventTheAntInTheBedChoiceA,
	eEventTheAntInTheBedChoiceB,
	eEventTheAntInTheBedResultA,
	eEventTheAntInTheBedResultB,

	eEventTheLoversFemaleTitle,		
	eEventTheLoversFemaleDesc,
	eEventTheLoversFemaleChoiceA,
	eEventTheLoversFemaleChoiceB,
	eEventTheLoversFemaleResultA,
	eEventTheLoversFemaleResultB,


	eEventTheLoversMaleTitle,		
	eEventTheLoversMaleDesc,
	eEventTheLoversMaleChoiceA,
	eEventTheLoversMaleChoiceB,
	eEventTheLoversMaleResultA,
	eEventTheLoversMaleResultB,

	eEventTheDroughtTitle,		
	eEventTheDroughtDesc,
	eEventTheDroughtChoiceA,
	eEventTheDroughtChoiceB,
	eEventTheDroughtResultA1,
	eEventTheDroughtResultA2,
	eEventTheDroughtResultB,


	eEventTheMedicalEmergencyTitle,		
	eEventTheMedicalEmergencyDesc,
	eEventTheMedicalEmergencyChoiceA,
	eEventTheMedicalEmergencyChoiceB,
	eEventTheMedicalEmergencyResultA1,
	eEventTheMedicalEmergencyResultA2,
	eEventTheMedicalEmergencyResultB,

	eEventTheMonsterButterflyTitle,		
	eEventTheMonsterButterflyDesc,
	eEventTheMonsterButterflyChoiceA,
	eEventTheMonsterButterflyChoiceB,
	eEventTheMonsterButterflyResultA,
	eEventTheMonsterButterflyResultB,


	eEventTheQuartzPhialTitle,		
	eEventTheQuartzPhialDesc,
	eEventTheQuartzPhialChoiceA,
	eEventTheQuartzPhialChoiceB,
	eEventTheQuartzPhialResultA1,
	eEventTheQuartzPhialResultA2,
	eEventTheQuartzPhialResultA3,
	eEventTheQuartzPhialResultB,

	eEventTheObsidianPhialTitle,		
	eEventTheObsidianPhialDesc,
	eEventTheObsidianPhialChoiceA,
	eEventTheObsidianPhialChoiceB,
	eEventTheObsidianPhialResultA1,
	eEventTheObsidianPhialResultA2,
	eEventTheObsidianPhialResultA3,
	eEventTheObsidianPhialResultB,

	eEventTheAmberPhialTitle,		
	eEventTheAmberPhialDesc,
	eEventTheAmberPhialChoiceA,
	eEventTheAmberPhialChoiceB,
	eEventTheAmberPhialResultA1,
	eEventTheAmberPhialResultA2,
	eEventTheAmberPhialResultA3,
	eEventTheAmberPhialResultB,


	eEventTheMangoAndThePapayaTitle,
	eEventTheMangoAndThePapayaDesc,
	eEventTheMangoAndThePapayaChoiceA,
	eEventTheMangoAndThePapayaChoiceB,
	eEventTheMangoAndThePapayaResultA1,
	eEventTheMangoAndThePapayaResultA2,
	eEventTheMangoAndThePapayaResultB,


	eEventTheCrateOfMangosPapayasAndBananasTitle,
	eEventTheCrateOfMangosPapayasAndBananasDesc,
	eEventTheCrateOfMangosPapayasAndBananasChoiceA,
	eEventTheCrateOfMangosPapayasAndBananasChoiceB,
	eEventTheCrateOfMangosPapayasAndBananasResultA1,
	eEventTheCrateOfMangosPapayasAndBananasResultA2,
	eEventTheCrateOfMangosPapayasAndBananasResultB,

	eEventTheBeeTitle,
	eEventTheBeeDesc,
	eEventTheBeeChoiceA,
	eEventTheBeeChoiceB,
	eEventTheBeeResultA,
	eEventTheBeeResultB,

	eEventTheNoisyBirdTitle,
	eEventTheNoisyBirdDesc,
	eEventTheNoisyBirdChoiceA,
	eEventTheNoisyBirdChoiceB,
	eEventTheNoisyBirdResultA,
	eEventTheNoisyBirdResultB,

	eEventTheHoleInTheHutTitle,
	eEventTheHoleInTheHutDesc,
	eEventTheHoleInTheHutChoiceA,
	eEventTheHoleInTheHutChoiceB,
	eEventTheHoleInTheHutResultA,
	eEventTheHoleInTheHutResultB,

	eEventTheRoyalJellyTitle,
	eEventTheRoyalJellyDesc,
	eEventTheRoyalJellyChoiceA,
	eEventTheRoyalJellyChoiceB,
	eEventTheRoyalJellyResultA,
	eEventTheRoyalJellyResultB,

	eEventTheShootingStarTitle,
	eEventTheShootingStarDesc,
	eEventTheShootingStarChoiceA,
	eEventTheShootingStarChoiceB,
	eEventTheShootingStarResultA,
	eEventTheShootingStarResultB,

	eEventTheReturnOfBigglesTitle,
	eEventTheReturnOfBigglesDesc,
	eEventTheReturnOfBigglesChoiceA,
	eEventTheReturnOfBigglesChoiceB,
	eEventTheReturnOfBigglesResultA,
	eEventTheReturnOfBigglesResultB,

	//END EVENT STRINGS

	//tech screen related strings

	eTechScienceLabel,
	eTechMedicineLabel,
	eTechAlchemyLabel,
	eTechRestorationLabel,
	eTechLeadershipLabel,
	eTechNatureLabel,
	eTechMagicLabel,

	eTechScienceInfo,
	eTechMedicineInfo,
	eTechAlchemyInfo,
	eTechRestorationInfo,
	eTechFarmingInfo,
	eTechNatureInfo,
	eTechMagicInfo,

	eTechLevel,
	eTechNextLevel,
	eTechCost,
	eTechPts,
	eTechResearchedNoPrice,
	eTechFullyResearched,
	eTechConfirmPath,
	eTechPathAlreadyChosen,

	//end tech screen related strings
	//END ISOLA STRINGS

	eRandomTip1,
	eRandomTip2,
	eRandomTip3,
	eRandomTip4,
	eRandomTip5,
	eRandomTip6,
	eRandomTip7,
	eRandomTip8,
	eRandomTip9,
	eRandomTip10,
	eRandomTip11,
	eRandomTip12,
	eRandomTip13,
	eRandomTip14,
	eRandomTip15,
	eRandomTip16,
	eRandomTip17,
	eRandomTip18,
	eRandomTip19,
	eRandomTip20,
	eRandomTip21,
	eRandomTip22,
	eRandomTip23,
	eRandomTip24,
	eRandomTip25,
	eRandomTip26,
	eRandomTip27,
	eRandomTip28,
	eRandomTip29,
	eRandomTip30,
	eRandomTip31,
	eRandomTip32,
	eRandomTip33,
	eRandomTip34,
	eRandomTip35,
	eRandomTip36,
	eRandomTip37,
	eRandomTip38,
	eRandomTip39,
	eRandomTip40,
	eRandomTip41,
	eRandomTip42,
	eRandomTip43,
	eRandomTip44,
	eRandomTip45,
	eRandomTip46,
	eRandomTip47,
	eRandomTip48,
	eRandomTip49,
	eRandomTip50,
	
	ePoints,

	eAge,     
	eStatus,  
	ePregnant,
	eSick,    
	eDead,    
	eOverviewSceneLabel,
	ePuzzlesSceneLabel,
	eCollectionsSceneLabel,
	eCollectionsTurtleShellsLabel,
	eCollectionsCoralLabel,
	eCollectionsTabletLabel,
	eCollectionsFeathersLabel,
	eCollectionsKeysLabel,
	eCollectionsOf,
	ePuzzlesButton,
	eStatisticsButton,
	eCompletedIn,
	eHours,
	eIsolaYears,
	eUnknown,
	eYourCash,

	ePlayer,
	ePleaseEnterANickName,
	eChangePlayer,
	eNewPlayer,
	
	eOK,
	eCancel,
	eDelete,
	eRefresh,
	eDeletePlayerConfirm,
#ifdef _MAC
	eChangeToWindowedConfirm,
#endif
	eChangeClothesConfirm,

	eAttemptingConnect,
	eStatsUpdated,	   
	eUpdateFailed,	   
	eNoStats,		   

	eCaringBaby,
	eWorriedFood,
	eStudyingMedicine,
	eWorriedHousing,
	eThinking,
	eBored,
	eDancing,
	eRelaxingBeach,
	eSitting,
	eCallingButterflies,
	eFishing,
	eLeavingWater,
	eEating,
	eReflecting,
	eCoolingFeet,
	eGettingDrink,
	eWateringField,
	eClearingBlockage,
	eEnjoyingBath,
	eConfused,
	eHonoringDead,
	eSayNoRoom,
	eSayNeedLeader,
	eSayOnlyBuilders,
	eNeedMoreToRepairLift,
	eAdmiringTreasure,
	eMakingParty,
	eObserving,
	eDigging,
	eFixingHut,
	eFoundingSchool,
	eTryingToPushBoulder,
	eRelaxing,

	eDemo,

	eYourStatistics,	
	eInternetStatistics,
	eRealHoursPlayed,	
	eYourRank,			
	ePressRefresh,		
	ePointsEarned,		
	eBabiesMade,		
	eFoodGathered,		
	ePeepsCured,		
	eCrabsFound,		
	eMaxPop,			
	eTotemsMade,			
	eOldestVillager,	
	eNumCrisis,			
	eTwinsBirthed,   
	eTripletsBirthed,
	ePuzzlesSolved,
	eAverage,	
	
	eAbundantSecurity,
	eAbundantSecurityDesc,
	eAncientElder,
	eAncientElderDesc,
	eAlchemyRUs,
	eAlchemyRUsDesc,
	eChildProdigy,
	eChildProdigyDesc,
	eFertile,
	eFertileDesc,
	eFungusAmongUs,
	eFungusAmongUsDesc,
	eLegendaryLeader,
	eLegendaryLeaderDesc,
	eProlificProcreation,
	eProlificProcreationDesc,
	eTechWonders,
	eTechWondersDesc,
	eTheDoctorIsIn,
	eTheDoctorIsInDesc,

	eSounds,
	eMusic,
	eVoiceover,
	eMusicTracks,
	eEnabled,
	eDisabled,

	eDifficulty,
	eEasy,
	eMedium,
	eHard,

	eGameSpeed,
	eStopTime,
	eNormal,
	eHalfSpeed,
	e2xSpeed,

	eFullscreen,
	eOn,
	eOff,

	eGameExpired,

	eEventPrizeTech,
	eEventPrizeFood,
	eEventPrizeSkel,
	eEventPrizeGain,
	eEventPrizeLose,

//	eTestId,

	eStringCount
};
class theStringManagerImpl;

class theStringManager
{
public:

	static theStringManager *Get();
	static void Destroy();

	ldwFont *clearFont;

	enum
	{
		eEnglish,
		eGerman,

		eLanguageCount
	};

	void LoadFonts();

	char *GetString(StringId stringId);
	void  GetStringFromNameGenderTemplate(char *dest,int maxLength,StringId templateId,const char *name,bool isMale,int awardAmount = 0,const char *name2 = 0, bool isMale2 = true);

	void SetLanguage(int language);
	int  GetLanguage();

#if _DEBUG
	bool CreateStringListFile();
#endif

protected:
	
	static theStringManager *mInstance;

	theStringManager();
	~theStringManager();

	theStringManagerImpl *mStringManager;
};
#endif